<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Thirdot</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('website/imgs/fav.svg')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/fontawesome-pro.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/icomoon.css')); ?>">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/website/app.css'], 'website/build'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/custom.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">

<style>
#preloader {
    display: flex;
    justify-content: center;
    align-items: center;
}

.has-submenu {
    position: relative;
}

.submenu {
    display: flex;             
    flex-wrap: wrap;   
    min-width: auto;
    padding: 12px 16px;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    border: 1px solid #eee;
    position: absolute;
    top: 100%;
    left: 0;
    visibility: hidden;
    opacity: 0;
    transform: translateY(10px);
    transition: opacity 0.3s ease, visibility 0.3s ease, transform 0.3s ease;
    z-index: 1000;
}

.has-submenu:hover  .submenu {
    visibility: visible;
    opacity: 1;
    transform: translateY(0);
}

.submenu li {
    display: inline-block;     
    width: auto;               
}

.submenu li a {
    padding: 8px 15px;
    white-space: nowrap;     
    font-size: 15px;
    color: #333;
    text-decoration: none;
    transition: background 0.2s ease, color 0.2s ease;
    display: block;
    border-radius: 4px;
    
}

.submenu li a:hover {
    background-color: #f1f5f9;
    color: #007bff;
}

.submenu-left {
    top: 0;
    left: auto !important;
    right: 100% !important;
    margin-right: 1px;
    transform: translateX(10px);
    transition: transform 0.3s ease;

    max-height: 350px; /
    overflow-y: auto;  
    overflow-x: hidden;
    display: block;    
    white-space: normal;
}

.submenu li:hover > .submenu-left {
    visibility: visible;
    opacity: 1;
    transform: translateX(0);
}

.submenu li.has-submenu > a::after {
    content: none !important;
}

.submenu li.has-submenu:hover > a::after {
    color: inherit;
    transform: none;
}

.submenu li:not(:last-child) a {
    border-bottom: none; 
}




</style>

</head>

<body>

    <div id="preloader">
        <img src="<?php echo e(asset('images/loader/loader.svg')); ?>" alt="">
    </div>

    <!-- Back to top start -->
    <div class="backtotop-wrap cursor-pointer">
        <svg class="backtotop-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Back to top end -->

    <div class="body-overlay"></div>
    <!-- search area end -->

    <!-- Offcanvas area start -->
    <div class="fix">
        <div class="offcanvas__info">
            <div class="offcanvas__wrapper">
                <div class="offcanvas__content">
                    <div class="offcanvas__top mb-40 d-flex justify-content-between align-items-center">
                        <div class="offcanvas__logo">
                            <a href="<?php echo e(Route('site.home')); ?>">
                                <img src="<?php echo e(asset('website/imgs/logo/thirdot-logo-white.png')); ?>" alt="Thirdot">
                            </a>
                        </div>
                        <div class="offcanvas__close">
                            <button>
                                <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="mobile-menu fix mb-40"></div>

                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas__overlay"></div>
    <div class="offcanvas__overlay-white"></div>
    <!-- Offcanvas area start -->

    <!-- Header area start -->
    <header>
        <div class="marquee">
  <p> Latest Updates: We have launched our new digital marketing services | Thirdot builds websites, apps & campaigns that deliver real results | Contact us today for a free consultation!</p>
</div>

        <div id="header-sticky" class="header-area">
            <div class="large-container">
                <div class="mega-menu-wrapper">
                    <div class="header-main">
                        <div class="header-left">
                            <div class="header-logo">
                                <a href="<?php echo e(route('site.home')); ?>">
                                    <img src="<?php echo e(asset('website/imgs/logo/logo1.png')); ?>" alt="header logo">
                                </a>
                            </div>
                        </div>
                        <div class="header-right d-flex justify-content-end">
                            <div class="mean__menu-wrapper d-none d-lg-block">
                                <div class="main-menu">
                                    <nav id="mobile-menu">
                                        <ul>
                                            <li class="navigation-links">
                                                <a href="<?php echo e(route('site.home')); ?>">Home</a>
                                            </li>
                                            <li class="navigation-links">
                                                <a href="<?php echo e(route('site.about')); ?>">About</a>
                                            </li>

                                            <li class="has-submenu">
                                                <a href="#">Services</a>
                                                <ul class="submenu">
                                                    <?php $__currentLoopData = services(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li class="has-submenu">
                                                            <a
                                                                href="<?php echo e(route('site.service-details', ['service_id' => $main->id])); ?>">
                                                                <?php echo e($main->title); ?>

                                                            </a>

                                                            <?php if($main->child_services->count()): ?>
                                                                <ul class="submenu submenu-left">
                                                                    <?php $__currentLoopData = $main->child_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li>
                                                                            <a
                                                                                href="<?php echo e(route('site.child-service-details', ['slug' => Str::slug($child->name)])); ?>">
                                                                                <?php echo e($child->name); ?>

                                                                            </a>
                                                                        </li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            <?php endif; ?>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </li>

                                            <li class="has-dropdown">
                                                <a href="<?php echo e(Route('site.blogs')); ?>">Blog</a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <!-- for wp -->
                                    <div class="header__hamburger ml-50 d-none">
                                        <button type="button" class="hamburger-btn offcanvas-open-btn">
                                            <span>01</span>
                                            <span>01</span>
                                            <span>01</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <!--<div class="search-toggle-open header-search my-auto">-->
                            <!--    <div class="search-icon">-->
                            <!--        <i class="icon-search"></i>-->
                            <!--    </div>-->
                            <!--</div>-->
                            <div class="header-action d-none d-xl-inline-flex gap-5">
                                <div class="header-link">
                                    <a class="primary-btn-1 btn-hover" href="<?php echo e(Route('site.contact')); ?>">
                                        GET A QUOTE &nbsp; | <i class="icon-right-arrow"></i>
                                        <span style= "top: 147.172px; left: 108.5px;"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="header-action">
                                <div class="header-link-1">
                                    <div class="icon">
                                        <i class="fal fa-phone-volume"></i>
                                    </div>
                                    <div class="content">
                                        <span>Call Us Now</span>
                                        <h6><a href="tel:+92 370 7537826">+92 370 7537826</a></h6>
                                    </div>
                                </div>
                            </div>
                            <div class="header__hamburger d-xl-none my-auto">
                                <div class="sidebar__toggle">
                                    <a class="bar-icon" href="javascript:void(0)">
                                        <i class="fa-light fa-bars-sort"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header><?php /**PATH C:\laragon\www\thirdot\resources\views/website/layouts/header.blade.php ENDPATH**/ ?>