<!doctype html>
<html class="no-js" lang="zxx">
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Thirdot</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('website/imgs/fav.svg')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/fontawesome-pro.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/icomoon.css')); ?>">
   <?php echo app('Illuminate\Foundation\Vite')(['resources/css/website/app.css'],'website/build'); ?>
</head>

<body>

    <!-- preloader start -->
    <div id="preloader">
        <div class="bd-loader-inner">
            <div class="bd-loader">
                <span class="bd-loader-item"></span>
                <span class="bd-loader-item"></span>
                <span class="bd-loader-item"></span>
                <span class="bd-loader-item"></span>
                <span class="bd-loader-item"></span>
                <span class="bd-loader-item"></span>
                <span class="bd-loader-item"></span>
                <span class="bd-loader-item"></span>
            </div>
        </div>
    </div>
    <!-- preloader start -->

    <!-- Back to top start -->
    <div class="backtotop-wrap cursor-pointer">
        <svg class="backtotop-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Back to top end -->

    <!-- search area start -->
    <div class="df-search-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="df-search-form">
                        <div class="df-search-close text-center mb-20">
                            <button class="df-search-close-btn df-search-close-btn"></button>
                        </div>
                        <form action="#">
                            <div class="df-search-input mb-10">
                                <input type="text" placeholder="Search here...">
                                <button type="submit"><i class="icon-search"></i></button>
                            </div>
                            <div class="df-search-category">
                                <span>Search by : </span>
                                <a href="#">Modified Wotech, </a>
                                <a href="#">Wotech Installation, </a>
                                <a href="#">Wotech Cornering, </a>
                                <a href="#">Wotech Renovation </a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="body-overlay"></div>
    <!-- search area end -->

    <!-- Offcanvas area start -->
    <div class="fix">
        <div class="offcanvas__info">
            <div class="offcanvas__wrapper">
                <div class="offcanvas__content">
                    <div class="offcanvas__top mb-40 d-flex justify-content-between align-items-center">
                        <div class="offcanvas__logo">
                            <a href="dashboard.html">
                                <img src="<?php echo e(asset('website/imgs/logo/logo1.png')); ?>" alt="Header Logo">
                            </a>
                        </div>
                        <div class="offcanvas__close">
                            <button>
                                <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="offcanvas__search mb-25">
                        <p class="text-white">Lorem ipsum dolor sit amet consectetur adipisicing elit. Voluptatum maxime
                            accusamus corrupti natus obcaecati vitae dignissimos, id officiis similique eos.</p>
                    </div>
                    <div class="mobile-menu fix mb-40"></div>
                    <div class="offcanvas__contact mt-30 mb-20">
                        <h4>Contact Info</h4>
                        <ul>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="fal fa-map-marker-alt"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a target="_blank" href="#">31 Park End St, Brockhampton, UK</a>
                                </div>
                            </li>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="far fa-phone"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a href="tel:+00112233665">+00112233665</a>
                                </div>
                            </li>
                            <li class="d-flex align-items-center">
                                <div class="offcanvas__contact-icon mr-15">
                                    <i class="fal fa-envelope"></i>
                                </div>
                                <div class="offcanvas__contact-text">
                                    <a href="tel:+012-345-6789"><span
                                            class="mailto:support@example.com">support@example.com</span></a>
                                </div>
                            </li>
                        </ul>
                    </div>
                    <div class="offcanvas__social">
                        <ul>
                            <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                            <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                            <li><a href="#"><i class="fab fa-youtube"></i></a></li>
                            <li><a href="#"><i class="fab fa-linkedin"></i></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas__overlay"></div>
    <div class="offcanvas__overlay-white"></div>
    <!-- Offcanvas area start -->

    <!-- Header area start -->
    <header>
        <div class="container-fluid bg-color-1">
            <div class="header-top">
                <div class="header-top-contact-info">
                    <span class="email p-relative"><a href="mailto:info@thirdot.com">info@thirdot.com</a></span>
                    <span class="time p-relative">Hours: Mon - Sat: 10.00 AM - 4.00 PM</span>
                </div>
                <div class="header-top-socials">
                    <span><a href="#"><i class="fab fa-facebook-f"></i></a></span>
                    <span><a href="#"><i class="fab fa-twitter"></i></a></span>
                    <span><a href="#"><i class="fab fa-linkedin-in"></i></a></span>
                    <span><a href="#"><i class="fab fa-youtube"></i></a></span>
                </div>
            </div>
        </div>
        <div id="header-sticky" class="header-area">
            <div class="large-container">
                <div class="mega-menu-wrapper">
                    <div class="header-main">
                        <div class="header-left">
                            <div class="header-logo">
                                <a href="index.html">
                                    <img src="<?php echo e(asset('website/imgs/logo/logo1.png')); ?>" alt="header logo">
                                </a>
                            </div>
                        </div>
                        <div class="header-right d-flex justify-content-end">
                            <div class="mean__menu-wrapper d-none d-lg-block">
                                <div class="main-menu">
                                    <nav id="mobile-menu">
                                        <ul>
                                            <li>
                                                <a href="<?php echo e(route('site.home')); ?>">Home</a>
                                            </li>
                                            <li>
                                                <a href="<?php echo e(route('site.about')); ?>">About</a>
                                            </li>
                                            <li>
                                                <a href="<?php echo e(Route('site.services')); ?>">Services</a>
                                            </li>
                                            <!-- <li>
                                                <a href="<?php echo e(Route('site.services')); ?>">Services</a>
                                                <ul class="submenu">
                                                    <li><a href="services.html">Services</a></li>
                                                    <li><a href="service-details.html">Service Details</a></li>
                                                </ul>
                                            </li> -->
                                            <li class="has-dropdown">
                                                <a href="<?php echo e(Route('site.blogs')); ?>">Blog</a>                                               
                                            </li>
                                        </ul>
                                    </nav>
                                    <!-- for wp -->
                                    <div class="header__hamburger ml-50 d-none">
                                        <button type="button" class="hamburger-btn offcanvas-open-btn">
                                            <span>01</span>
                                            <span>01</span>
                                            <span>01</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="search-toggle-open header-search my-auto">
                                <div class="search-icon">
                                    <i class="icon-search"></i>
                                </div>
                            </div>
                            <div class="header-action d-none d-xl-inline-flex gap-5">
                                <div class="header-link">
                                    <a class="primary-btn-1 btn-hover" href="<?php echo e(Route('site.contact')); ?>">
                                        GET A QUOTE &nbsp; | <i class="icon-right-arrow"></i>
                                        <span style="top: 147.172px; left: 108.5px;"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="header-action">
                                <div class="header-link-1">
                                    <div class="icon">
                                        <i class="fal fa-phone-volume"></i>
                                    </div>
                                    <div class="content">
                                        <span>Call Us Now</span>
                                        <h6><a href="tel:2085550112">+208-555-0112</a></h6>
                                    </div>
                                </div>
                            </div>
                            <div class="header__hamburger d-xl-none my-auto">
                                <div class="sidebar__toggle">
                                    <a class="bar-icon" href="javascript:void(0)">
                                        <i class="fa-light fa-bars-sort"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
<?php /**PATH D:\laragon\www\thirdot-live\resources\views/website/layouts/header.blade.php ENDPATH**/ ?>