
<?php $__env->startSection('content'); ?>
<?php
use Illuminate\Support\Str;
?>
<main>
   <div class="breadcrumb__area theme-bg-1 p-relative pt-160 pb-160">
      <div class="breadcrumb__thumb" data-background="<?php echo e(asset('website/imgs/resources/page-title-bg-1.png')); ?>"></div>
      <div class="breadcrumb__thumb_2" data-background="<?php echo e(asset('website/imgs/resources/page-title-bg-2.png')); ?>"></div>
      <div class="small-container">
         <div class="row justify-content-center">
            <div class="col-xxl-12">
               <div class="breadcrumb__wrapper p-relative">
                  <h2 class="breadcrumb__title">Blog Details</h2>
                  <div class="breadcrumb__menu">
                     <nav>
                        <ul>
                           <li><span><a href="<?php echo e(Route('site.home')); ?>">Home</a></span></li>
                           <li><span>Blog Details</span></li>
                        </ul>
                     </nav>
                  </div>
               </div>
            </div>
         </div>
      </div>
   </div>

   <section class="blog-details-page section-space">
      <div class="small-container">
         <div class="row">
            <div class="col-xxl-8 col-xl-8 col-lg-8">
               <figure class="blog-thumb w-img">
                  <img src="<?php echo e(asset('images/blogs/'.$blog->thumbnail)); ?>" alt="">
               </figure>
               <ul class="blog-post-meta mb-20 mt-40">
                  <li><a href="#"><i class="fal fa-user"></i>By Admin</a></li>
                  <li><a href="#"><i class="fal fa-calendar-days"></i> <?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('d F, Y')); ?></a></li>
                  <li><a href="#"><i class="fal fa-tag"></i>Technology</a></li>
               </ul>
               <hr>
               <h3 class="blog-details-title mb-30 mt-20"><a href="#"><?php echo e($blog->title); ?></a></h3>

               <?php echo $blog->blog_desc; ?>


               <div class="postbox__share-wrapper mb-60">
                  <div class="row g-4 align-items-center">
                     <div class="col-xl-7 col-lg-12">
                        <div class="tagcloud tagcloud-sm">
                           <span>Tags:</span>
                           <a href="#">business</a>
                           <a href="#">marketing</a>
                           <a href="#">services</a>
                        </div>
                     </div>
                     <div class="col-xl-5 col-lg-12">
                        <div class="postbox__share text-xl-end">
                           <span>Share:</span>
                           <a href="#"><i class="fab fa-linkedin-in"></i></a>
                           <a href="#"><i class="fab fa-twitter"></i></a>
                           <a href="#"><i class="fab fa-facebook-f"></i></a>
                        </div>
                     </div>
                  </div>
               </div>

            </div>
            <div class="col-xxl-4 col-xl-4 col-lg-4">
               <div class="blog-sidebar">
                  <aside>
                     <div class="blog-widget-1 mb-30">
                        <h5 class="blog-widget-title p-relative mb-45">Search</h5>
                        <div class="search-form p-relative">
                           <form action="#">
                              <input type="text" placeholder="Search here">
                              <button type="submit"><i class="icon-search"></i></button>
                           </form>
                        </div>
                     </div>
                     <div class="blog-widget-2 mb-30">
                        <h5 class="blog-widget-title p-relative mb-45">Category</h5>
                        <ul class="blog-categories-list">
                           <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <li>
                              <a href="#">
                                 <span><?php echo e($cat->name); ?></span>
                              </a>
                           </li>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                     </div>
                     <div class="blog-widget-3 mb-30">
                        <h5 class="blog-widget-title p-relative mb-45">Resent Post</h5>
                        <div class="blog-post-sidebar-area">
                           <?php $__currentLoopData = $recents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $r): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <div class="blog-post-sidebar mt-3">
                                 <a class="w-img blog-sidebar-thumb" href="<?php echo e(route('site.blog.details', ['slug' => Str::slug($blog->title)])); ?>">
                                    <img src="<?php echo e(asset('images/blogs/'.$r->thumbnail)); ?>" alt="<?php echo e($r->title); ?>">
                                 </a>
                                 <div class="content">
                                    <span><i class="fal fa-calendar-alt"></i> <?php echo e(\Carbon\Carbon::parse($r->created_at)->format('d F, Y')); ?></span>
                                    <h6 class="blog-sidebar-post-title mt-10"><a href="<?php echo e(route('site.blog.details', ['slug' => Str::slug($blog->title)])); ?>"><?php echo e($r->title); ?></a></h6>
                                 </div>
                              </div>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                     </div>
                     <div class="blog-widget-4 mb-30">
                        <h5 class="blog-widget-title p-relative mb-45">Tags</h5>
                        <div class="tagcloud">
                           <a href="#">business</a>
                           <a href="#">marketing</a>
                           <a href="#">solution</a>
                           <a href="#">SMM</a>
                           <a href="#">startup</a>
                           <a href="#">strategy </a>
                           <a href="#">SEO </a>
                           <a href="#">services</a>
                        </div>
                     </div>
                     <div class="service-widget-2 mb-30">
                        <figure class="w-img">
                           <img src="<?php echo e(asset('website/imgs/service/service-widget-1.jpg')); ?>" alt="">
                        </figure>
                        <div class="content bg-color-1 text-center">
                           <div class="icon-box p-relative">
                              <i class="fal fa-phone-volume"></i>
                           </div>
                           <h5>Need Help? Call Here</h5>
                           <a class="pt-25 pb-25 phone" href="tel:+92 370 7537826">+92 370 7537826</a>
                           <div class="btn-box">
                              <a class="primary-btn-1 btn-hover" href="<?php echo e(Route('site.contact')); ?>">
                                 GET A QUOTE &nbsp; | <i class="icon-right-arrow"></i>
                                 <span style="top: 147.172px; left: 108.5px;"></span>
                              </a>
                           </div>
                        </div>
                     </div>
                  </aside>
               </div>
            </div>
         </div>
      </div>
   </section>
</main>
<?php $__env->startSection('scripts'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('website.layouts.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\thirdot\resources\views/website/content/blog-details.blade.php ENDPATH**/ ?>