
<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2"><?php echo e($title); ?></h1>
            </div>
        </div>

        <?php if($courses->count() == 0): ?>
            <div class="alert alert-info">No courses available.</div>
        <?php else: ?>
            <div class="row">
                <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-4 col-lg-6 col-md-6 mb-3">
                        <a href="<?php echo e(route('driver.courses', $course->id)); ?>" class="text-decoration-none">
                            <div class="card custom-card h-100">
                                <div class="card-body">
                                    <h5 class="mb-2"><?php echo e($course->title); ?></h5>
                                    <?php if(!empty($course->description)): ?>
                                        <p class="text-muted mb-0">
                                            <?php echo e(\Illuminate\Support\Str::limit($course->description, 120)); ?>

                                        </p>
                                    <?php endif; ?>
                                </div>
                                <div class="card-footer d-flex justify-content-between align-items-center">
                                    <span class="text-muted">Course #<?php echo e($course->order_index); ?></span>
                                    <span class="btn btn-sm btn-primary">View</span>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('driver.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\thirdot-misbah\lms-lms\resources\views/driver/courses/index.blade.php ENDPATH**/ ?>