

<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="container-fluid">

        
        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <h1 class="page-title fw-medium fs-18 mb-2">Edit Quiz Question</h1>
            <a href="<?php echo e(route('quiz_question.index')); ?>" class="btn btn-secondary">Back</a>
        </div>

        
        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <form method="POST" action="<?php echo e(route('quiz_question.update', $question->id)); ?>" data-parsley-validate>
                            <?php echo csrf_field(); ?>

                            
                            <div class="row mb-4">
                                <div class="col-md-6 mb-3">
                                    <label for="course_id">Course <span class="text-danger">*</span></label>
                                    <select name="course_id" id="course_id" class="form-control" required>
                                        <option value="">-- Select Course --</option>
                                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($course->id); ?>" <?php if($course->id == $question->course_id): ?> selected <?php endif; ?>>
                                            <?php echo e($course->title); ?>

                                        </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="order_index">Order Index</label>
                                    <input type="number" id="order_index" name="order_index" class="form-control" value="<?php echo e($question->order_index); ?>" min="1">
                                </div>

                                <div class="col-md-3 mb-3">
                                    <label for="points">Points</label>
                                    <input type="number" id="points" name="points" class="form-control" value="<?php echo e($question->points); ?>" min="1">
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label for="question_text">Question <span class="text-danger">*</span></label>
                                    <textarea name="question_text" id="question_text" class="form-control" rows="3" required><?php echo e($question->question_text); ?></textarea>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label for="question_type">Question Type</label>
                                    <select name="question_type" id="question_type" class="form-control">
                                        <option value="mcq_single" <?php if($question->question_type == 'mcq_single'): ?> selected <?php endif; ?>>MCQ (Single Correct)</option>
                                        <option value="multi_select" <?php if($question->question_type == 'multi_select'): ?> selected <?php endif; ?>>Multi Select</option>
                                        <option value="true_false" <?php if($question->question_type == 'true_false'): ?> selected <?php endif; ?>>True / False</option>
                                    </select>
                                </div>

                                <div class="col-md-8 mb-3">
                                    <label for="explanation_text">Explanation</label>
                                    <textarea name="explanation_text" id="explanation_text" class="form-control" rows="2"><?php echo e($question->explanation_text); ?></textarea>
                                </div>
                            </div>

                            <hr>

                            
                            <div id="options-section">
                                <h5>Answer Options</h5>
                                <div id="options-wrapper"></div>
                                <button type="button" id="add-option-btn" class="btn btn-sm btn-secondary mt-2" onclick="addOption()">+ Add Option</button>
                            </div>

                            <hr>

                            <button type="submit" class="btn btn-primary">Update Quiz Question</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<?php $__env->startSection('scripts'); ?>
<script>
    let optionIndex = 0;
    const existingOptions = <?php echo json_encode($question->options, 15, 512) ?>;

    function renderOptions(type) {
        const wrapper = document.getElementById('options-wrapper');
        const addBtn = document.getElementById('add-option-btn');
        wrapper.innerHTML = '';
        optionIndex = 0;

        // True / False Question
        if (type === 'true_false') {
            addBtn.style.display = 'none';
            ['True', 'False'].forEach((text, i) => {
                const opt = existingOptions[i];
                const checked = opt?.is_correct ? 'checked' : '';
                const valueText = opt?.option_text ?? text;

                wrapper.insertAdjacentHTML('beforeend', `
                    <div class="row mb-2">
                        <div class="col-md-7">
                            <input type="text" class="form-control" name="options[${i}][option_text]" value="${valueText}">
                        </div>
                        <div class="col-md-2 text-center">
                            <input type="radio" name="correct_tf" value="${i}" ${checked} required> Correct
                        </div>
                    </div>
                `);
            });
            optionIndex = 2;
            return;
        }

        addBtn.style.display = 'inline-block';

        // Existing options for MCQ / Multi-select
        if (existingOptions.length > 0) {
            existingOptions.forEach((opt, i) => {
                let correctInput = (type === 'mcq_single') ?
                    `<input type="radio" name="correct_single" value="${i}" ${opt.is_correct ? 'checked':''} required>` :
                    `<input type="checkbox" name="options[${i}][is_correct]" value="1" ${opt.is_correct ? 'checked':''}>`;

                wrapper.insertAdjacentHTML('beforeend', `
                    <div class="row mb-2 align-items-center option-row" data-index="${i}">
                        <div class="col-md-6">
                            <input type="text" name="options[${i}][option_text]" class="form-control" placeholder="Option ${i+1}" value="${opt.option_text}" required>
                        </div>
                        <div class="col-md-2 text-center">${correctInput} Correct</div>
                        <div class="col-md-3">
                            <input type="text" name="options[${i}][feedback_if_selected]" class="form-control" placeholder="Feedback" value="${opt.feedback_if_selected ?? ''}">
                        </div>
                        <div class="col-md-1 text-center">
                            <button type="button" class="btn btn-sm btn-danger" onclick="removeOption(this)">✕</button>
                        </div>
                    </div>
                `);
                optionIndex++;
            });
        } else {
            addOption();
            addOption();
        }
    }

    function addOption() {
        const type = document.getElementById('question_type').value;
        const wrapper = document.getElementById('options-wrapper');

        let correctInput = (type === 'mcq_single') ?
            `<input type="radio" name="correct_single" value="${optionIndex}" required>` :
            `<input type="checkbox" name="options[${optionIndex}][is_correct]" value="1">`;

        wrapper.insertAdjacentHTML('beforeend', `
            <div class="row mb-2 align-items-center option-row" data-index="${optionIndex}">
                <div class="col-md-6">
                    <input type="text" name="options[${optionIndex}][option_text]" class="form-control" placeholder="Option ${optionIndex+1}" required>
                </div>
                <div class="col-md-2 text-center">${correctInput} Correct</div>
                <div class="col-md-3">
                    <input type="text" name="options[${optionIndex}][feedback_if_selected]" class="form-control" placeholder="Feedback">
                </div>
                <div class="col-md-1 text-center">
                    <button type="button" class="btn btn-sm btn-danger" onclick="removeOption(this)">✕</button>
                </div>
            </div>
        `);
        optionIndex++;
    }

    function removeOption(btn) {
        btn.closest('.option-row').remove();
    }

    document.getElementById('question_type').addEventListener('change', function() {
        renderOptions(this.value);
    });

    // Initial render
    renderOptions(document.getElementById('question_type').value);
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\lms\resources\views/admin/quiz/edit.blade.php ENDPATH**/ ?>