<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Thirdot</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('website/imgs/fav.svg')); ?>">
    <!-- Primary favicon -->
    <link rel="icon" type="image/svg+xml" href="<?php echo e(asset('website/imgs/fav.png')); ?>">
    <!-- Fallback for older browsers -->
    <link rel="alternate icon" href="<?php echo e(asset('website/imgs/fav.png')); ?>">
    <!-- Safari pinned tab -->
    <link rel="mask-icon" href="<?php echo e(asset('website/imgs/fav.png')); ?>" color="#000000">
    <!-- Legacy -->
    <link rel="shortcut icon" href="<?php echo e(asset('website/imgs/fav.png')); ?>">


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css" />

    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/css2.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/icomoon.css')); ?>">
    <link rel="stylesheet" async href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/website/app.css'], 'website/build'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/style.css')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        @media (max-width: 991px) {

            /* Hide desktop navbar */
            .desktop-nav {
                display: none !important;
            }

            /* Offcanvas container */
            .mobile-nav {
                background-color: #fff;
                width: 300px;
            }

            /* Logo */
            .mobile-logo {
                height: 40px;
            }

            /* Menu list */
            .mobile-menu {
                list-style: none;
                padding: 0;
                margin: 0;
            }

            .mobile-menu li {
                border-bottom: 1px solid #eee;
            }

            .mobile-menu li:last-child {
                border-bottom: none;
            }

            /* MAIN LINKS (Same as desktop nav) */
            .mobile-menu a,
            .mobile-dropdown-btn,
            .mobile-submenu-btn {
                font-family: 'Inter', sans-serif;
                font-weight: 500;
                font-size: 1.5rem;
                color: #444;
                padding: 14px 0;
                width: 100%;
                display: flex;
                justify-content: space-between;
                align-items: center;
                background: transparent;
                border: none;
                text-decoration: none;
            }

            /* Hover / active */
            .mobile-menu a:hover,
            .mobile-dropdown-btn:hover,
            .mobile-submenu-btn:hover {
                color: #92278f;
            }

            /* Bootstrap handles open/close */
            .mobile-submenu,
            .mobile-childmenu {
                list-style: none;
                padding-left: 15px;
            }

            /* Submenu font sizes */
            .mobile-submenu a {
                font-size: 1.35rem;
            }

            .mobile-childmenu a {
                font-size: 1.25rem;
                color: #666;
            }

            /* Icons */
            .mobile-menu i {
                font-size: 0.85rem;
                opacity: 0.7;
                transition: transform 0.3s ease;
            }

            /* CTA button */
            .mobile-nav .btn-primary {
                background-color: #92278f;
                border: none;
                font-size: 1.2rem;
                padding: 12px;
                border-radius: 30px;
                width: 100%;
            }
        }

        @media (min-width: 992px) {
            #mobileNav {
                display: none !important;
            }
        }


        @media (min-width: 992px) {
            #mobileNav {
                display: none !important;
            }

            .navbar .dropdown {
                position: relative;
            }

            .navbar .dropdown-menu {
                display: block;
                opacity: 0;
                visibility: hidden;
                transform: translateY(8px);
                pointer-events: none;
                transition: all 0.25s ease;
                position: absolute;
                top: 100%;
                z-index: 9999;
            }

            .navbar .dropdown:hover>.dropdown-menu {
                opacity: 1;
                visibility: visible;
                transform: translateY(0);
                pointer-events: auto;
            }

            /* Hover bridge */
            .navbar .dropdown::after {
                content: "";
                position: absolute;
                left: 0;
                top: 100%;
                width: 100%;
                height: 12px;
            }

            /* Submenu hover */
            .dropdown-submenu {
                position: relative;
            }

            .dropdown-submenu>.dropdown-menu {
                top: 0;
                left: 100%;
                opacity: 0;
                visibility: hidden;
                transform: translateX(8px);
                pointer-events: none;
                transition: all 0.25s ease;
                position: absolute;
            }

            .dropdown-submenu:hover>.dropdown-menu {
                opacity: 1;
                visibility: visible;
                transform: translateX(0);
                pointer-events: auto;
            }
        }

        @media (max-width: 991px) {

            /* Bootstrap collapse scroll */
            .navbar-collapse {
                max-height: 80vh;
                overflow-y: auto;
            }

            /* MAIN dropdown (Services) */
            .navbar .dropdown-menu {
                display: none;
                position: static !important;
                transform: none !important;
                opacity: 1 !important;
                visibility: visible !important;
                pointer-events: auto !important;
                box-shadow: none;
                margin-top: 10px;
            }

            .navbar .dropdown-menu.show {
                display: block;
            }

            /* SUBMENU */
            .dropdown-submenu>.dropdown-menu {
                display: none;
                margin-left: 15px;
                box-shadow: none;
            }

            .dropdown-submenu>.dropdown-menu.show {
                display: block;
            }
        }

        .dropdown-menu {
            border-radius: 10px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
        }

        a.nav-link {
            font-weight: 500 !important;
            color: #444;
            margin: 0 15px;
            font-size: 1.5rem !important;
        }

        .mobile-submenu,
        .mobile-childmenu {
            padding-left: 15px;
        }

        .mobile-dropdown-btn,
        .mobile-submenu-btn {
            cursor: pointer;
        }
    </style>
    <script type="importmap">
    {
        "imports": {
        "react": "https://esm.sh/react@^19.2.3",
        "lucide-react": "https://esm.sh/lucide-react@^0.562.0",
        "react/": "https://esm.sh/react@^19.2.3/"
        }
    }
  </script>
</head>

<body data-bs-theme="light">

    <!--<div class="offcanvas offcanvas-start mobile-nav d-lg-none" tabindex="-1" id="mobileNav">-->
    <!--    <div class="offcanvas-header">-->
    <!--        <img src="<?php echo e(asset('website/imgs/logo/logo1.png')); ?>" class="mobile-logo">-->
    <!--        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>-->
    <!--    </div>-->

    <!--    <div class="offcanvas-body">-->
    <!--        <ul class="mobile-menu">-->

    <!--            <li><a href="<?php echo e(route('site.home')); ?>">Home</a></li>-->
    <!--            <li><a href="<?php echo e(route('site.about')); ?>">About</a></li>-->

    <!--            <li class="mobile-dropdown">-->
    <!--                <button class="mobile-dropdown-btn" data-bs-toggle="collapse" data-bs-target="#servicesMenu">-->

    <!--                    Services <i class="fa fa-chevron-down"></i>-->
    <!--                </button>-->

    <!--                <ul class="collapse mobile-submenu" id="servicesMenu">-->
    <!--                    <?php $__currentLoopData = services(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
    <!--                        <li>-->
    <!--                            <button class="mobile-submenu-btn" data-bs-toggle="collapse"-->
    <!--                                data-bs-target="#service-<?php echo e($main->id); ?>">-->

    <!--                                <?php echo e($main->title); ?>-->
    <!--                                <?php if($main->child_services->count()): ?>-->
    <!--                                    <i class="fa fa-chevron-right"></i>-->
    <!--                                <?php endif; ?>-->
    <!--                            </button>-->

    <!--                            <?php if($main->child_services->count()): ?>-->
    <!--                                <ul class="collapse mobile-childmenu" id="service-<?php echo e($main->id); ?>">-->
    <!--                                    <?php $__currentLoopData = $main->child_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
    <!--                                        <li>-->
    <!--                                            <a-->
    <!--                                                href="<?php echo e(route('site.child-service-details', ['slug' => Str::slug($child->name)])); ?>">-->
    <!--                                                <?php echo e($child->name); ?>-->
    <!--                                            </a>-->
    <!--                                        </li>-->
    <!--                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
    <!--                                </ul>-->
    <!--                            <?php endif; ?>-->
    <!--                        </li>-->
    <!--                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
    <!--                </ul>-->
    <!--            </li>-->


    <!--            <li><a href="<?php echo e(route('site.blogs')); ?>">Blog</a></li>-->
    <!--            <li><a href="<?php echo e(route('site.contact')); ?>">Contact</a></li>-->
    <!--        </ul>-->

    <!--        <a href="<?php echo e(route('site.contact')); ?>" class="btn btn-primary w-100 mt-4">Get Started</a>-->
    <!--    </div>-->
    <!--</div>-->

    <div class="offcanvas offcanvas-start mobile-nav d-lg-none" tabindex="-1" id="mobileNav">
        <div class="offcanvas-header">
            <img src="<?php echo e(asset('website/imgs/logo/logo1.png')); ?>" class="mobile-logo">
            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"></button>
        </div>

        <div class="offcanvas-body">
            <ul class="mobile-menu" id="mobileMainMenu">

                <li><a href="<?php echo e(route('site.home')); ?>">Home</a></li>
                <li><a href="<?php echo e(route('site.about')); ?>">About</a></li>

                <li class="mobile-dropdown">
                    <button class="mobile-dropdown-btn" type="button" data-target="#servicesMenu">
                        Services 
                        <!--<i class="fa fa-chevron-down"></i>-->
                    </button>

                    <ul class="mobile-submenu collapse" id="servicesMenu">
                        <?php $__currentLoopData = services(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <button class="mobile-submenu-btn" type="button"
                                    data-target="#service-<?php echo e($main->id); ?>">
                                    <?php echo e($main->title); ?>

                                    <?php if($main->child_services->count()): ?>
                                        <!--<i class="fa fa-chevron-right"></i>-->
                                    <?php endif; ?>
                                </button>



                                <?php if($main->child_services->count()): ?>
                                    <ul class="mobile-childmenu collapse" id="service-<?php echo e($main->id); ?>">
                                        <?php $__currentLoopData = $main->child_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li>
                                                <a
                                                    href="<?php echo e(route('site.child-service-details', ['slug' => Str::slug($child->name)])); ?>">
                                                    <?php echo e($child->name); ?>

                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </li>


                <li><a href="<?php echo e(route('site.blogs')); ?>">Blog</a></li>
                <li><a href="<?php echo e(route('site.contact')); ?>">Contact</a></li>
            </ul>

            <a href="<?php echo e(route('site.contact')); ?>" class="btn btn-primary w-100 mt-4">Get Started</a>
        </div>
    </div>
    <nav class="navbar navbar-expand-lg fixed-top" id="mainNav">
        <div class="container">
            <a class="navbar-brand" href="<?php echo e(route('site.home')); ?>">
                <img src="<?php echo e(asset('website/imgs/logo/logo1.png')); ?>" alt="Thirdot" class="navbar-logo">
            </a>

            <button class="btn mobile-menu-btn d-lg-none" data-bs-toggle="offcanvas" data-bs-target="#mobileNav">
                <i data-lucide="menu"></i>
            </button>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav mx-auto">
                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('site.home')); ?>">Home</a></li>
                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('site.about')); ?>">About</a></li>
                    <!--<li class="nav-item dropdown">-->
                    <!--    <a class="nav-link dropdown-toggle" href="<?php echo e(route('site.services')); ?>" role="button" data-bs-toggle="dropdown"-->
                    <!--        aria-expanded="true">-->
                    <!--        Services-->
                    <!--    </a>-->


                    <!--    <ul class="dropdown-menu shadow-lg border-0 mt-3">-->

                    <!--        <?php $__currentLoopData = services(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                    <!--            <li class="dropdown-submenu">-->
                    <!--                <a class="dropdown-item d-flex justify-content-between submenu-toggle"-->
                    <!--                    href="<?php echo e(route('site.service-details', ['service_id' => $main->id])); ?>"-->
                    <!--                    role="button">-->

                    <!--                    <?php echo e($main->title); ?>-->

                    <!--                    <?php if($main->child_services->count()): ?>-->
                    <!--                        <i class="fa-solid fa-angle-right"></i>-->
                    <!--                    <?php endif; ?>-->
                    <!--                </a>-->

                    <!--                <?php if($main->child_services->count()): ?>-->
                    <!--                    <ul class="dropdown-menu shadow border-0">-->
                    <!--                        <?php $__currentLoopData = $main->child_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>-->
                    <!--                            <li>-->
                    <!--                                <a class="dropdown-item"-->
                    <!--                                    href="<?php echo e(route('site.child-service-details', ['slug' => Str::slug($child->name)])); ?>">-->
                    <!--                                    <?php echo e($child->name); ?>-->
                    <!--                                </a>-->
                    <!--                            </li>-->
                    <!--                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->
                    <!--                    </ul>-->
                    <!--                <?php endif; ?>-->
                    <!--            </li>-->
                    <!--        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>-->

                    <!--    </ul>-->
                    <!--</li>-->
                    <li class="nav-item dropdown">
                        <a class="nav-link" href="<?php echo e(route('site.services')); ?>">
                            Services
                        </a>
                        <a class="nav-link dropdown-toggle d-none" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false" ></a>
                    
                        <ul class="dropdown-menu shadow-lg border-0 mt-3">
                            <?php $__currentLoopData = services(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="dropdown-submenu">
                                    <a class="dropdown-item d-flex justify-content-between submenu-toggle"
                                       href="<?php echo e(route('site.service-details', ['service_id' => $main->id])); ?>">
                                        <?php echo e($main->title); ?>

                                        <?php if($main->child_services->count()): ?>
                                            <i class="fa-solid fa-angle-right"></i>
                                        <?php endif; ?>
                                    </a>
                                    <?php if($main->child_services->count()): ?>
                                        <ul class="dropdown-menu shadow border-0">
                                            <?php $__currentLoopData = $main->child_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <a class="dropdown-item"
                                                       href="<?php echo e(route('site.child-service-details', ['slug' => Str::slug($child->name)])); ?>">
                                                        <?php echo e($child->name); ?>

                                                    </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>

                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('site.blogs')); ?>">Blog</a>
                    <li class="nav-item"><a class="nav-link" href="<?php echo e(route('site.contact')); ?>">Contact</a></li>
                </ul>
                <a href="<?php echo e(route('site.contact')); ?>" class="btn btn-primary-nexus">Get Started</a>
            </div>
        </div>
    </nav>

    <section class="hero" id="home">
        <div class="container">
            <div class="row align-items-center g-5">
                <div class="col-lg-6">
                    <div class="d-inline-flex align-items-center px-3 py-2 rounded-pill mb-4"
                        style="background: rgba(145, 39, 142, 0.1);">
                        <span class="badge bg-purple rounded-circle p-1 me-2"
                            style="background: var(--primary-color); width: 10px; height: 10px;">&nbsp;</span>
                        <small class="text-purple fw-bold text-uppercase ls-1">The Future of Software</small>
                    </div>
                    <h1>Engineering <span class="text-purple">Brilliance</span> Through Code.</h1>
                    <p class="banner_text  mb-5">We transform complex challenges into elegant software solutions.
                        From high-growth startups to Fortune 500 enterprises, we deliver digital excellence.</p>
                    <div class="d-flex flex-wrap gap-3 mt-2" id="home_buttons">
                        <button class="btn btn-primary-nexus  btn-xl py-3 px-5">Start Your Project</button>
                        <button class="btn btn-outline-dark btn-xl py-3 px-5 rounded-pill fw-bold">
                            View Portfolio
                        </button>

                    </div>
                </div>
                <div class="col-lg-6 mt-5">
                    <div class="hero-img-wrapper">
                        <img src="<?php echo e(asset('website/imgs/indexBanner/9.png')); ?>" alt="Thirdot Dashboard"
                            class="img-fluid hero-img">
                        <div class="position-absolute bottom-0 start-0 p-4 w-100"
                            style="border-bottom-left-radius: 30px; border-bottom-right-radius: 30px;">
                            <h5 class="text-white fw-bold mb-0">Innovation First</h5>
                            <p class="text-white-50 small mb-0">Designing for the modern web</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="container">
            <div class="row text-center g-4">
                <div class="col-6 col-md-3">
                    <div class="stat-card">
                        <h2 class="counter" data-target="250">0</h2>
                        <p>Projects Done</p>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stat-card">
                        <h2 class="counter" data-target="120">0</h2>
                        <p>Happy Clients</p>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stat-card">
                        <h2 class="counter" data-target="15">0</h2>
                        <p>Years of Exp.</p>
                    </div>
                </div>
                <div class="col-6 col-md-3">
                    <div class="stat-card">
                        <h2 class="counter" data-target="45">0</h2>
                        <p>Talented Devs</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section class="py-5 bg-light" id="services">
        <div class="container py-5">
            <div class="text-center mb-5 pb-3 ">
                <h6 class="text-purple fw-bold text-uppercase tracking-widest">Our Services</h6>
                <h2 class="display-5 fw-bold">Solutions We Provide</h2>
            </div>
            <div class="row g-4 services-details mt-5 pt-4" id="services-details">


            </div>
        </div>
    </section>

    <!-- Portfolio Section -->
    <section class="py-5" id="portfolio">
        <div class="container py-5">
            
            <div class="justify-content-center text-center mb-5 pb-4">
                <div>
                    <h6 class="text-purple fw-bold text-uppercase tracking-widest">Showcase</h6>
                    <h2 class="display-5 fw-bold mb-">Recent Projects</h2>
                </div>
                
            </div>
            <div class="row mt-5 pt-4" id="portfolio-div">


            </div>
        </div>
    </section>

    <!-- Blogs Section -->



    <section class="py-5 bg-light" id="blogs">
        <div class="container py-5">
            <div class="text-center mb-5 pb-3">
                <h6 class="text-purple fw-bold text-uppercase tracking-widest">Insights</h6>
                <h2 class="display-5 fw-bold">Latest Articles</h2>
            </div>
            <div class="row g-4 mt-5 pt-4" id="blog-cards">


            </div>
        </div>
    </section>


    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="row g-5" style="    border-bottom: 1px solid rgba(255, 255, 255, .2);    padding: 50px 0;">
                <div class="col-lg-4 col-sm-12">
                    <div class="d-flex align-items-center mb-4 justify-content-center justify-content-lg-start">
                        <img loading="lazy" src="<?php echo e(asset('website/imgs/logo/thirdot-logo-white.png')); ?>"
                            class="footer-logo" alt="Thirdot" width="50%">
                    </div>
                    <p class="pe-lg-5 text-white">Thirdot delivers innovative web, app, eCommerce, SEO, and digital
                        marketing solutions that drive growth and impact.</p>
                    <div class="mt-4">
                        <a href="https://www.facebook.com/thirdot3?mibextid=wwXIfr&rdid=9XUtQjiNMzp5zjxm&share_url=https%3A%2F%2Fwww.facebook.com%2Fshare%2F1BHFde2HSU%2F%3Fmibextid%3DwwXIfr#"
                            class="social-icon"><i class="fab fa-facebook-f" style="width:18px;"></i></a>
                        <a href="https://www.youtube.com/@Thirdot-3" class="social-icon"><i class="fab fa-youtube"
                                style="width:18px;"></i></a>
                        <a href="https://www.linkedin.com/company/thirdot/?viewAsMember=true" class="social-icon"><i
                                class="fab fa-linkedin-in" style="width:18px;"></i></a>
                        <a href="https://www.instagram.com/thirdot3/?igsh=MWNvbHc0bmI2aGI1dg%3D%3D#"
                            class="social-icon"><i class="fab fa-instagram" style="width:18px;"></i></a>
                    </div>
                </div>
                <div class=" col-lg-2 col-sm-12">
                    <h5 class="fw-bold mb-4 text-white">Qiuck Links</h5>
                    <a href="<?php echo e(route('site.home')); ?>" class="footer-link">Home</a>
                    <a href="<?php echo e(route('site.about')); ?>" class="footer-link">About</a>
                    <a href="<?php echo e(route('site.services')); ?>" class="footer-link">Services</a>
                    <a href="<?php echo e(route('site.blogs')); ?>" class="footer-link">Blog</a>
                    <a href="<?php echo e(route('site.contact')); ?>" class="footer-link">Get a Quote</a>
                </div>
                <div class=" col-lg-2 col-sm-12">
                    <h5 class="fw-bold mb-4 text-white">Blogs</h5>

                    <ul class="footer-contact-info" style="color:white; list-style: none; padding-left: 0;">
                        <?php $__currentLoopData = latest_blogs(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li style="margin-bottom: 8px;">
                                <a href="#"
                                    style="color: white; text-decoration: none;"><?php echo e($blog->title); ?></a>
                            </li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
                <div class="col-lg-4 col-sm-12" id="contact">
                    <h5 class="fw-bold mb-4 text-white">Contact</h5>
                    <p class=" mb-4 text-white">Connect with us right now for any query and quotation</p>
                    <div class="input-group mb-3">
                        <ul class="footer-contact-list">
                            <li>
                                <i class="fa-regular fa-envelope social-icon" style="font-size:14px;"></i>
                                <span><a href="mailto:info@thirdot.com"
                                        class="text-white text-decoration-none footer-link"
                                        style="font-size: 15px;margin:0px;">info@thirdot.com</a></span>
                            </li>
                            <li>
                                <i class="fa-solid fa-phone social-icon" style="font-size:14px;"></i>
                                <span><a href="tel:+923001234567" class="text-white text-decoration-none footer-link"
                                        style="font-size: 15px;margin:0px;">+92 300
                                        1234567</a></span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            
            <div class="small-container">
                <div class="text-white pt-30 pb-30">
                    <div class="left-area text-center">
                        <span>All Rights Reserved Copyright © <?php echo e(\Carbon\Carbon::now()->format('Y')); ?> By <a
                                href="<?php echo e(Route('site.home')); ?>" class="underline-link">Thirdot</a></span>
                    </div>
                </div>
            </div>
        </div>

    </footer>
    <script>
        let get_quote_url = "<?php echo e(route('site.contact')); ?>"
    </script>


    <script src="<?php echo e(asset('website/theme-js/jquery-3.7.1.min.js')); ?>"></script>

    <script defer src="<?php echo e(asset('website/theme-js/wow.js')); ?>"></script>
    <script defer src="<?php echo e(asset('website/theme-js/magnific-popup.js')); ?>"></script>
    <script async src="<?php echo e(asset('website/theme-js/meanmenu.min.js')); ?>"></script>
    <script>
        $('#preloader').addClass('d-none');
    </script>
    <script defer src="<?php echo e(asset('website/theme-js/slick.min.js')); ?>"></script>
    <script defer src="<?php echo e(asset('website/theme-js/swiper.min.js')); ?>"></script>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/js/app.js'], 'website/build'); ?>
    <script defer type="text/javascript" src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
    <script>
        $.ajaxSetup({
            headers: {
                "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
            },
        });
    </script>
  
    <script src="<?php echo e(asset('website/custom-js/lucide.min.js')); ?>"></script>
    <script src="<?php echo e(asset('website/custom-js/home.js')); ?>"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  

</body>

</html>
<?php /**PATH /home/u905916028/domains/thirdot.com/public_html/resources/views/website/content/index.blade.php ENDPATH**/ ?>