<!doctype html>
<html class="no-js" lang="zxx">

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title>Thirdot</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset('website/imgs/fav.svg')); ?>">
        <!-- Primary favicon -->
    <link rel="icon" type="image/svg+xml" href="<?php echo e(asset('website/imgs/fav.svg')); ?>">
    <!-- Fallback for older browsers -->
    <link rel="alternate icon" href="<?php echo e(asset('website/imgs/fav.svg')); ?>">
    <!-- Safari pinned tab -->
    <link rel="mask-icon" href="<?php echo e(asset('website/imgs/fav.svg')); ?>" color="#000000">
    <!-- Legacy -->
    <link rel="shortcut icon" href="<?php echo e(asset('website/imgs/fav.svg')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/fontawesome-pro.css')); ?>">
    
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/7.0.1/css/all.min.css"
        integrity="sha512-2SwdPD6INVrV/lHTZbO2nodKhrnDdJK9/kg2XD1r9uGqPo1cUbujc+IYdlYdEErWNu69gVcYgdxlmVmzTWnetw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/css2.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/bootstrap.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/icomoon.css')); ?>">
    
    
    <link rel="stylesheet" async href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/website/app.css'], 'website/build'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/custom.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('website/theme-css/font-awsome-6.css')); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">
    <!-- Meta Pixel Code -->
    
    <script>
        !function(f,b,e,v,n,t,s)
        {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
        n.callMethod.apply(n,arguments):n.queue.push(arguments)};
        if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
        n.queue=[];t=b.createElement(e);t.async=!0;
        t.src=v;s=b.getElementsByTagName(e)[0];
        s.parentNode.insertBefore(t,s)}(window, document,'script',
        'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '754403880949998');
        fbq('track', 'PageView');
    </script>

<noscript><img height="1" width="1" style="display:none" src="https://www.facebook.com/tr?id=754403880949998&ev=PageView&noscript=1"/></noscript>
<!-- End Meta Pixel Code -->

<style>



.has-submenu {
    position: relative;
}

.submenu {
  position: absolute;
  top: 100%;
  left: 0;
  margin: 0;
  background: #fff;
  border: 1px solid #eee;
  border-radius: 8px;

  box-shadow: 0 10px 30px rgba(0,0,0,0.08);
  visibility: hidden;
  opacity: 0;
  transition: opacity 0.3s ease, visibility 0.3s ease;
  z-index: 1000;
  min-width: 200px;
}


.has-submenu:hover > .submenu {
  visibility: visible;
  opacity: 1;
}



  .submenu-left {
    top: 0;
    left: auto !important;
    right: 100% !important;
    margin-right: 1px;
    transform: translateX(-10px);
    transition: transform 0.3s ease;

    display: block;
    white-space: normal;
    position: absolute;
    background-color: #fff;
    border-radius: 8px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    border: 1px solid #eee;

    max-height: 300px;        
    overflow-y: auto;         
    overflow-x: hidden;

    visibility: hidden;
    opacity: 0;
    z-index: 1000;
}


.submenu li.has-submenu:hover > .submenu-left {
  visibility: visible;
  opacity: 1;
  transform: translateX(0);
}


/* Wrapper for relative positioning */
.custom-dropdown-wrapper {
    position: relative;
    width: 100%;
    display: inline-block;
}

/* Base select styling */
.custom-dropdown-wrapper select {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid #ced4da;
    border-radius: 8px;
    background-color: #fff;
    font-size: 15px;
    color: #333;
    cursor: pointer;
    appearance: none; /* removes default arrow */
    transition: all 0.3s ease;
}

/* Hover & focus effects */
.custom-dropdown-wrapper select:hover {
    border-color: #0f0d1d;
}

.custom-dropdown-wrapper select:focus {
    outline: none;
    border-color: #0f0d1d;
    box-shadow: 0 0 5px rgba(15, 13, 29, 0.3);
}

/* Custom arrow */
.custom-dropdown-wrapper .custom-arrow {
    position: absolute;
    top: 50%;
    right: 16px;
    width: 0;
    height: 0;
    pointer-events: none;
    border-left: 6px solid transparent;
    border-right: 6px solid transparent;
    border-top: 6px solid #333;
    transform: translateY(-50%);
    transition: all 0.3s ease;
}

/* Optional: rotate arrow when open */
.custom-dropdown-wrapper select:focus + .custom-arrow {
    transform: translateY(-50%) rotate(180deg);
}

/* Dropdown option styling (browser dependent) */
.custom-dropdown-wrapper select option {
    padding: 10px 14px;
    font-size: 15px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .custom-dropdown-wrapper select {
        padding: 10px 12px;
        font-size: 14px;
    }
    .custom-dropdown-wrapper .custom-arrow {
        right: 12px;
    }
}


@media (max-width: 991px) {

  .submenu {
    position: static;
    margin: 0 !important;
    padding: 0 !important;
    opacity: 1 !important;
    visibility: visible !important;
    box-shadow: none;
    border: none;
  
  }


  .submenu-left {
    position: static !important;
        margin: 0 !important;
    padding: 0 !important;
    max-height: none !important;
    overflow: visible !important;
    box-shadow: none !important;
    border: none !important;
    transform: none !important;
    visibility: visible !important;
    opacity: 1 !important;
    margin: 0 !important;
  }

  .submenu li.has-submenu:hover > .submenu-left {
  transform: translateX(0);
  }
}


</style>

</head>

<body>

    <div id="preloader">
        <img src="<?php echo e(asset('images/loader/loader.svg')); ?>" alt="">
    </div>

    <!-- Back to top start -->
    <div class="backtotop-wrap cursor-pointer">
        <svg class="backtotop-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
            <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
        </svg>
    </div>
    <!-- Back to top end -->

    <div class="body-overlay"></div>
    <!-- search area end -->

    <!-- Offcanvas area start -->
    <div class="fix">
        <div class="offcanvas__info">
            <div class="offcanvas__wrapper">
                <div class="offcanvas__content">
                    <div class="offcanvas__top mb-40 d-flex justify-content-between align-items-center">
                        <div class="offcanvas__logo">
                            <a href="<?php echo e(Route('site.home')); ?>">
                                <img loading="lazy"  src="<?php echo e(asset('website/imgs/logo/thirdot-logo-white.png')); ?>" alt="Thirdot">
                            </a>
                        </div>
                        <div class="offcanvas__close">
                            <button>
                                <i class="fal fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="mobile-menu fix mb-40"></div>

                </div>
            </div>
        </div>
    </div>
    <div class="offcanvas__overlay"></div>
    <div class="offcanvas__overlay-white"></div>
    <!-- Offcanvas area start -->

    <!-- Header area start -->
    <header>
        <div class="marquee">
  <p> Latest Updates: We have launched our new digital marketing services | Thirdot builds websites, apps & campaigns that deliver real results | Contact us today for a free consultation!</p>
</div>

        <div id="header-sticky" class="header-area">
            <div class="large-container">
                <div class="mega-menu-wrapper">
                    <div class="header-main">
                        <div class="header-left">
                            <div class="header-logo">
                                <a href="<?php echo e(route('site.home')); ?>">
                                    <img loading="lazy" style="width: 170px;height=39px" src="<?php echo e(asset('website/imgs/logo/logo1.png')); ?>" alt="Thirdot">
                                </a>
                            </div>
                        </div>
                        <div class="header-right d-flex justify-content-end">
                            <div class="mean__menu-wrapper d-none d-lg-block">
                                <div class="main-menu">
                                    <nav id="mobile-menu">
                                        <ul>
                                            <li class="navigation-links">
                                                <a href="<?php echo e(route('site.home')); ?>">Home</a>
                                            </li>
                                            <li class="navigation-links">
                                                <a href="<?php echo e(route('site.about')); ?>">About</a>
                                            </li>

                                            <li class="has-submenu">
                                                <a href="<?php echo e(route('site.services')); ?>">Services</a>
                                                <ul class="submenu">
                                                    <?php $__currentLoopData = services(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $main): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li class="has-submenu">
                                                            <a
                                                                href="<?php echo e(route('site.service-details', ['service_id' => $main->id])); ?>">
                                                                <?php echo e($main->title); ?>

                                                            </a>

                                                            <?php if($main->child_services->count()): ?>
                                                                <ul class="submenu submenu-left">
                                                                    <?php $__currentLoopData = $main->child_services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <li>
                                                                            <a
                                                                                href="<?php echo e(route('site.child-service-details', ['slug' => Str::slug($child->name)])); ?>">
                                                                                <?php echo e($child->name); ?>

                                                                            </a>
                                                                        </li>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </ul>
                                                            <?php endif; ?>
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </li>

                                            <li class="has-dropdown">
                                                <a href="<?php echo e(Route('site.blogs')); ?>">Blog</a>
                                            </li>
                                            <li class="has-dropdown-new d-block d-lg-none">
                                                <a href="<?php echo e(Route('site.contact')); ?>">Get A Quote</a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <!-- for wp -->
                                    <div class="header__hamburger ml-50 d-none">
                                        <button type="button" class="hamburger-btn offcanvas-open-btn">
                                            <span>01</span>
                                            <span>01</span>
                                            <span>01</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <!--<div class="search-toggle-open header-search my-auto">-->
                            <!--    <div class="search-icon">-->
                            <!--        <i class="icon-search"></i>-->
                            <!--    </div>-->
                            <!--</div>-->
                            <div class="header-action d-none d-xl-inline-flex gap-5">
                                <div class="header-link">
                                    <a class="primary-btn-1 btn-hover" href="<?php echo e(Route('site.contact')); ?>">
                                        GET A QUOTE &nbsp; | <i class="icon-right-arrow"></i>
                                        <span style= "top: 147.172px; left: 108.5px;"></span>
                                    </a>
                                </div>
                            </div>
                            <div class="header-action">
                                <div class="header-link-1">
                                    <div class="icon">
                                        <i class="fal fa-phone-volume"></i>
                                    </div>
                                    <div class="content">
                                        <span>Call Us Now</span>
                                        <h6><a href="tel:+92 370 7537826">+92 370 7537826</a></h6>
                                    </div>
                                </div>
                            </div>
                            <div class="header__hamburger d-xl-none my-auto">
                                <div class="sidebar__toggle">
                                    <a class="bar-icon" href="javascript:void(0)">
                                        <i class="fa-light fa-bars-sort"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header><?php /**PATH /home/u905916028/domains/thirdot.com/public_html/resources/views/website/layouts/header.blade.php ENDPATH**/ ?>