

<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2"><?php echo e($title); ?></h1>
            </div>
            <div>
                <a href="<?php echo e(route('courses.index')); ?>" class="btn btn-secondary">Back</a>
            </div>
        </div>

        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <form method="POST" enctype="multipart/form-data" action="<?php echo e(route('courses.update', ['id' => $course->id])); ?>" data-parsley-validate>
                            <?php echo csrf_field(); ?>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label>Program (optional)</label>
                                    <select name="program_id" class="form-control">
                                        <option value="">-- Select Program --</option>
                                        <?php $__currentLoopData = $programs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($p->id); ?>" <?php echo e($course->program_id == $p->id ? 'selected' : ''); ?>>
                                                <?php echo e($p->title); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Order Index</label>
                                    <input type="number" name="order_index" class="form-control" value="<?php echo e($course->order_index); ?>" min="1" required>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Title</label>
                                    <input type="text" name="title" class="form-control" value="<?php echo e($course->title); ?>" required>
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Description</label>
                                    <input type="text" name="description" class="form-control" value="<?php echo e($course->description); ?>">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Video URL</label>
                                    <input type="text" name="video_url" class="form-control" value="<?php echo e($course->video_url); ?>">
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label>Slides URL (optional link)</label>
                                    <input type="text" name="slides_url" class="form-control" value="<?php echo e($course->slides_url); ?>" placeholder="Optional: Google Drive / URL">
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label>Transcript</label>
                                    <textarea name="transcript" id="transcript_editor" class="form-control" rows="6"><?php echo $course->transcript; ?></textarea>
                                </div>

                                <div class="col-md-12 mb-3">
                                    <label>Upload Files (PPT / Word / Excel / PDF)</label>
                                    <input type="file" name="attachments[]" class="form-control" multiple
                                           accept=".pdf,.ppt,.pptx,.doc,.docx,.xls,.xlsx">
                                    <small class="text-muted">You can select multiple files.</small>
                                </div>


                                <div class="col-md-4 mb-3">
                                    <label>Has Quiz</label>
                                    <select name="has_quiz" class="form-control">
                                        <option value="0" <?php echo e($course->has_quiz ? '' : 'selected'); ?>>No</option>
                                        <option value="1" <?php echo e($course->has_quiz ? 'selected' : ''); ?>>Yes</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Passing Percent</label>
                                    <input type="number" name="passing_percent" class="form-control" min="0" max="100" value="<?php echo e($course->passing_percent); ?>">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Unlimited Attempts</label>
                                    <select name="allow_unlimited_attempts" class="form-control">
                                        <option value="1" <?php echo e($course->allow_unlimited_attempts ? 'selected' : ''); ?>>Yes</option>
                                        <option value="0" <?php echo e($course->allow_unlimited_attempts ? '' : 'selected'); ?>>No</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Max Attempts</label>
                                    <input type="number" name="max_attempts" class="form-control" min="1" value="<?php echo e($course->max_attempts); ?>">
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Unlock Type</label>
                                    <select name="unlock_type" class="form-control" required>
                                        <option value="open" <?php echo e($course->unlock_type == 'open' ? 'selected' : ''); ?>>Open</option>
                                        <option value="after_prerequisite" <?php echo e($course->unlock_type == 'after_prerequisite' ? 'selected' : ''); ?>>After Prerequisite</option>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Prerequisite Course</label>
                                    <select name="prerequisite_course_id" class="form-control">
                                        <option value="">-- None --</option>
                                        <?php $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($c->id); ?>" <?php echo e($course->prerequisite_course_id == $c->id ? 'selected' : ''); ?>>
                                                <?php echo e($c->title); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label>Prerequisite Condition</label>
                                    <select name="prerequisite_condition" class="form-control" required>
                                        <option value="completed" <?php echo e($course->prerequisite_condition == 'completed' ? 'selected' : ''); ?>>Completed</option>
                                        <option value="passed" <?php echo e($course->prerequisite_condition == 'passed' ? 'selected' : ''); ?>>Passed</option>
                                    </select>
                                </div>
                            </div>

                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
    <?php $__env->startSection('scripts'); ?>
        <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script> 
        <script> 
           ClassicEditor .create(document.querySelector('#transcript_editor'), { toolbar: [ 'heading','|', 'bold','italic','underline','|', 'bulletedList','numberedList','|', 'link','insertTable','|', 'undo','redo' ] }) .catch(error => { console.error(error); }); 
        </script>
        <?php if(session('success')): ?>
            <script>
                notify('success', <?php echo json_encode(session('success'), 15, 512) ?>);
            </script>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <script>
                notify('danger', <?php echo json_encode($errors->first(), 15, 512) ?>);
            </script>
        <?php endif; ?>
    <?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\lms\resources\views/admin/courses/edit.blade.php ENDPATH**/ ?>