
<?php $__env->startSection('content'); ?>
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2"><?php echo e($title); ?></h1>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <?php
                            if(isset($blog->id)){
                                $formurl = route('admin.add_edit_blog',['id' => $blog->id]);
                            }else{
                                $formurl = route('admin.add_edit_blog');
                            }
                        ?>
                        <form id="add-edit-blog" data-parsley-validate data-url="<?php echo e($formurl); ?>">
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Title <span class="text-danger">*</span></label>
                                <input type="text" placeholder="Enter Title" minlength="3" maxlength="50" name="title" value="<?php echo e(isset($blog->title) ? $blog->title :""); ?>" class="form-control" id="title" required="true">
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Short Description <span class="text-danger">*</span></label>
                                <textarea name="short_desc" class="form-control" placeholder="Enter Short Description" id="description" required minlength="10"><?php echo e(isset($blog->short_desc) ? $blog->short_desc : ""); ?></textarea>
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Select Category <span class="text-danger">*</span></label>
                                <select class="form-control" id="category" data-toggle="select2" data-placeholder="Select Category" name="category_id" aria-hidden="true">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e(isset($blog->category_id) && $blog->category_id == $category->id ? 'selected' : ""); ?> value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Thumbnail <span class="text-danger">*</span></label>
                                <input type="file" name="thumbnail" class="form-control" id="thumbnail" <?php echo e(!isset($blog->thumbnail) ? 'required' : ''); ?>>
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Meta Title <span class="text-danger">*</span></label>
                                <input type="text" value="<?php echo e(isset($blog->meta_title) ? $blog->meta_title :""); ?>" placeholder="Enter Meta Title" minlength="3" maxlength="50" name="meta_title" class="form-control" id="meta_title" required="true">
                            </div>
                            <div class="form-group col-6 mb-3">
                                <label for="floatingInput">Meta Description <span class="text-danger">*</span></label>
                                <input type="text" value="<?php echo e(isset($blog->meta_desc) ? $blog->meta_desc :""); ?>" placeholder="Meta Description" minlength="3" maxlength="50" name="meta_desc" class="form-control" id="meta_desc" required="true">
                            </div>
                            <div class="form-group col-12 mb-3">
                                <div id="editor">
                                    <?php if(isset($blog->blog_desc)): ?>
                                    <?php echo $blog->blog_desc; ?>

                                    <?php else: ?>
                                        <h4>Write something awsome</h4>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="col-12 float-right">
                                <button id="add-btn" onclick="save_form(event,this)" class="btn btn-primary">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startSection('scripts'); ?>
<link rel="stylesheet" href="<?php echo e(asset('admin/libs/quill/quill.snow.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('admin/libs/quill/quill.bubble.css')); ?>">

<script src="<?php echo e(asset('admin/libs/quill/quill.js')); ?>"></script>
<script src="<?php echo e(asset('admin/custom-js/blogs.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\laragon\www\thirdot-web\resources\views/admin/blogs/add-edit.blade.php ENDPATH**/ ?>