@extends('admin.layout.main')
@section('content')
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="my-4 page-header-breadcrumb d-flex align-items-center justify-content-between flex-wrap gap-2">
            <div>
                <h1 class="page-title fw-medium fs-18 mb-2">{{$title}}</h1>
            </div>
            <div>
                <button type="button" data-bs-toggle="modal" data-bs-target="#add-modal" class="btn btn-primary">
                    Add Program
                </button>
            </div>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="data-table" class="table table-bordered text-nowrap w-100">
                                <thead>
                                    <tr>
                                        <th>Sno</th>
                                        <th>Title</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="add-modal" tabindex="-1" aria-labelledby="add-modal" data-bs-keyboard="false"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title" id="staticBackdropLabel2">Add {{$title}}</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="add-form" data-parsley-validate data-url="{{ route('programs.add_edit') }}">
                    <div class="form-group mb-3">
                        <label for="floatingInput">Title</label>
                        <input type="text" name="title" class="form-control" id="title" required="true">
                    </div>
                    <div class="form-group mb-3">
                        <label for="floatingInput">Description</label>
                        <input type="text" name="description" class="form-control" id="description" required="true">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" id="add-btn" onclick="save_form(event,this)" class="btn btn-primary">Submit</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="edit-modal" tabindex="-1" aria-labelledby="add-modal" data-bs-keyboard="false"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h6 class="modal-title" id="staticBackdropLabel2">Edit {{$title}}</h6>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="edit-form" data-parsley-validate>
                    
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <button type="button" id="update-btn" onclick="update_form(event,this)" class="btn btn-primary">Submit</button>
            </div>
        </div>
    </div>
</div>
@section('scripts')
<script src="{{ asset('admin/custom-js/modules-helper.js') }}"></script>
<script src="{{ asset('admin/custom-js/modules.js') }}"></script>
@endsection
@endsection