$(document).ready(function () {
    let $servicesContainer = $("#services-details");

    // show loader before AJAX call
    $servicesContainer.html(`
        <div class="col-12 text-center my-5">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
            <h4 class="mt-3">Loading services...</h4>
        </div>
    `);

    $.ajax({
        url: "/services",
        type: "POST",
        dataType: "json",
        success: function (response) {
            if (response.status == 1 && response.payload.length > 0) {
                let html = "";
                response.payload.forEach(service => {
                    html += `
                        <div class="col-xxl-4 col-xl-4 col-lg-4 mb-15">
                            <div class="service-slider-area p-relative">
                                <figure class="image w-img">
                                    <img src="images/services/${service.image}" alt="${service.title}">
                                </figure>
                                <div class="content">
                                    <div class="icon-box">
                                        <img src="images/services/icons/${service.icon_image}" alt="icon">
                                    </div>
                                    <h4 class="mb-15">
                                        <a href="service-details/${service.id}">${service.title}</a>
                                    </h4>
                                    <p class="mb-25">${service.description}</p>
                                    <a href="/service-details/${service.id}" class="service-btn">
                                        Get More Detail <i class="icon-arrow-right-double"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    `;
                });
                $servicesContainer.html(html);
            } else {
                $servicesContainer.html(`
                    <div class="col-12 text-center my-5">
                        <h4>No services found</h4>
                    </div>
                `);
            }
        },
        error: function () {
            $servicesContainer.html(`
                <div class="col-12 text-center my-5">
                    <h4>Error loading services</h4>
                </div>
            `);
        }
    });
});
