// Initialize Lucide Icons
lucide.createIcons();

// Navbar Scroll Effect
window.addEventListener('scroll', function () {
    const navbar = document.getElementById('mainNav');
    if (window.scrollY > 50) {
        navbar.classList.add('scrolled');
    } else {
        navbar.classList.remove('scrolled');
    }
});

// Animated Counters
const animateCounters = () => {
    const counters = document.querySelectorAll('.counter');
    const speed = 200;

    counters.forEach(counter => {
        const updateCount = () => {
            const target = +counter.getAttribute('data-target');
            const count = +counter.innerText;
            const inc = target / speed;

            if (count < target) {
                counter.innerText = Math.ceil(count + inc);
                setTimeout(updateCount, 1);
            } else {
                counter.innerText = target;
            }
        };
        updateCount();
    });
};

// Trigger Counter Animation on Scroll
const statsSection = document.querySelector('.stats-section');
let animated = false;

const observer = new IntersectionObserver((entries) => {
    if (entries[0].isIntersecting && !animated) {
        animateCounters();
        animated = true;
    }
}, { threshold: 0.5 });

observer.observe(statsSection);
$(document).ready(function () {
    let $servicesContainer = $("#services-details");
    let $blogsContainer = $("#blog-cards");
    let $portfolioContainer = $("#portfolio-div");

    // Show loaders
    const loaderHtml = `
        <div class="col-12 text-center my-5">
            <div class="spinner-border text-primary" role="status">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    `;
    $servicesContainer.html(loaderHtml);
    $blogsContainer.html(loaderHtml);
    $portfolioContainer.html(loaderHtml);

    setTimeout(() => {
        $.ajax({
            url: "/",
            type: "POST",
            dataType: "json",
            success: function (response) {
                console.log(response);

                // 🔹 SERVICES
                if (response.status === '1' && response.payload.services.length > 0) {
                    let html = ``;
                    response.payload.services.forEach(service => {
                        html += `
                
                        <div class="col-md-6 col-lg-4">
                        <div class="service-card service-card-img">
                            <div class="service-img">
                                <img loading="lazy" src="images/services/${service.image}" alt="img">
                                <!-- ICON OVER IMAGE -->
                                <div class="service-icon"><img loading="lazy" style="width: 60%;" src="images/services/icons/${service.icon_image}" alt="img"></div>
                            </div>

                            <div class="service-content">
                                <h4>${service.title}</h4>
                                <p>
                                    ${service.description}
                                </p>
                            </div>
                        </div>
                    </div>
                        
                    `;
                    });
                    $servicesContainer.html(html);
                } else {
                    $servicesContainer.html(`<div class="col-12 text-center text-white">No services found</div>`);
                }
                let allPortfolio = [];
                // 🔹 PORTFOLIO
                if (response.status === '1' && response.payload.portfolio.length > 0) {
                    allPortfolio = response.payload.portfolio;
                    renderPortfolio("all");
                } else {
                    $portfolioContainer.html(`<div class="col-12 text-center">No portfolio found</div>`);
                }

                function renderPortfolio(filter) {
                    let html = ``;

                    allPortfolio.forEach(item => {
                        if (filter === "all" || item.category === filter) {
                            html += `
             

                        <div class="col-md-6 col-lg-4 portfolio-item" data-category="${item.category}">
                            <div class="portfolio-card">
                                <img loading="lazy" src="images/portfolio/${item.image}" class="portfolio-img" alt="${item.title}">
                                <div class="portfolio-overlay">
                                    <h4 class="text-white fw-bold"><a href="${item.link}">${item.description}</a></h4>
                                    <div class="icon-area">
                                                <a href="${item.link}"><i class="icon-arrow-up"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
            `;
                        }
                    });

                    $portfolioContainer.html(html);
                }

                // 🔹 BLOGS
                if (response.status === '1' && response.payload.blogs.length > 0) {
                    let html = ``;
                    response.payload.blogs.forEach(blog => {
                        const formattedDate = new Date(blog.created_at).toLocaleDateString('en-US', {
                            day: 'numeric',
                            month: 'long',
                            year: 'numeric'
                        });
                        html += `
                        <div class="col-lg-4">
                            <div class="blog-card">
                                <img src="/images/blogs/${blog.thumbnail}" alt="${blog.title}" class="blog-img">
                                <div class="blog-content">
                                    <p class=" small fw-bold mb-2">${formattedDate}</p>
                                    <h4 class="fw-bold mb-3">${blog.title}</h4>
                                    <p class="description">${blog.short_desc}</p>
                                    <a href="#"
                                        class="text-purple fw-bold text-decoration-none d-inline-flex align-items-center">
                                        Read More <i class="fa-solid fa-arrow-right" class="ms-2 mx-2" style="width:16px;margin-left: 5px;"></i>
                                    </a>
                                </div>
                            </div>
                        </div>

                       
                                
                       
                    `;
                    });
                    $blogsContainer.html(html);
                } else {
                    $blogsContainer.html(`<div class="col-12 text-center text-white">No blogs found</div>`);
                }
            },
            error: function () {
                let errorHtml = `<div class="col-12 text-center text-white">Failed to load data.</div>`;
                $servicesContainer.html(errorHtml);
                $blogsContainer.html(errorHtml);
                $portfolioContainer.html(errorHtml);
            }, complete: function () {
                setTimeout(function () {
                    new Swiper(".service-active-1", {
                        loop: true,
                        spaceBetween: 30,
                        slidesPerView: 1,
                        speed: 900,
                        navigation: {
                            nextEl: ".service-1-button-next",
                            prevEl: ".service-1-button-prev",
                        },
                        breakpoints: {
                            768: { slidesPerView: 2 },
                            1024: { slidesPerView: 3 }
                        }
                    });

                    new Swiper(".project-active-1", {
                        loop: true,
                        spaceBetween: 20,
                        slidesPerView: 1,
                        speed: 900,
                        navigation: {
                            nextEl: ".project-1-button-next",
                            prevEl: ".project-1-button-prev",
                        },
                        breakpoints: {
                            768: { slidesPerView: 2 },
                            1024: { slidesPerView: 3 }
                        }
                    });

                }, 650);
            }
        }, 900);
    })
});


$(document).on("click", "#portfolioTabs .nav-link", function (e) {
    e.preventDefault();

    $("#portfolioTabs .nav-link").removeClass("active");
    $(this).addClass("active");

    const filter = $(this).data("filter");
    renderPortfolio(filter);
});

document.querySelectorAll('.mobile-dropdown-btn, .mobile-submenu-btn').forEach(btn => {
    btn.addEventListener('click', function () {
        const target = document.querySelector(this.dataset.target);
        if (!target) return;

        const isOpen = target.classList.contains('show');

        // Close all sibling collapses
        const siblings = target.parentElement.parentElement.querySelectorAll('.collapse.show');
        siblings.forEach(el => {
            if (el !== target) {
                el.classList.remove('show');
                const btn = document.querySelector(`[data-target="#${el.id}"]`);
                if (btn) btn.setAttribute('aria-expanded', 'false');
            }
        });

        // Toggle current
        target.classList.toggle('show', !isOpen);
        this.setAttribute('aria-expanded', !isOpen);
    });
});


document.querySelectorAll('.mobile-dropdown-btn, .mobile-submenu-btn').forEach(btn => {
    btn.addEventListener('click', function () {
        const target = document.querySelector(this.dataset.target);
        if (!target) return;

        const isOpen = target.classList.contains('show');

        // Close all sibling collapses
        const siblings = target.parentElement.parentElement.querySelectorAll('.collapse.show');
        siblings.forEach(el => {
            if (el !== target) {
                el.classList.remove('show');
                const btn = document.querySelector(`[data-target="#${el.id}"]`);
                if (btn) btn.setAttribute('aria-expanded', 'false');
            }
        });

        // Toggle current
        target.classList.toggle('show', !isOpen);
        this.setAttribute('aria-expanded', !isOpen);
    });
});