let datalist = (params) => {
    var {
        start,
        end,
        label,
        value_type,
        spinerType,
    } = params;

    var title = "";
    range = "";
    // var start_date = start.format("YYYY-MM-DD");

    $("#data-table").DataTable({
        ...window.datatableConfig,
        ajax: {
            url: listRoute,
            type: "POST",
            data: {

            },
        },
        oLanguage: {
            ...window.datatableConfig.oLanguage,
            sSearchPlaceholder: "Search"
        },
        aoColumns: columns,
        initComplete: function (settings, json) {

        },
        drawCallback: function (settings) {
            init_tooltip();
        }
    });
    $("#datepicker").find("span.date_range").html(range);
    $("#datepicker").find("span.date_title").html(title);
};


$(document).ready(function () {
    // var picker = $("#datepicker");

    var param = {
        // start: moment().subtract(3, 'days'),
        // end: moment(),
        label: '',
        value_type: "",
        spinerType: "",
    }

    // init_datepicker(picker, param.start, param.end, datalist);
    datalist(param);
});


let save_form = (e, element) => {
    var form_id = $(element).closest('.modal-content').find('form').attr('id');
    var title = $(element).html()
    var forms = $("#" + form_id);
    var route = $("#" + form_id).data('url');

    forms.parsley().validate();
    initLoader('add-btn', '', 'btn-primary');
    if (!forms.parsley().isValid()) {
        destroyLoader('add-btn', title, 'btn-primary')
        return false;
    }
    e.preventDefault();
    if (forms.parsley().isValid()) {
        var formdata = new FormData($("#" + form_id)[0]);
        formdata.append('type', 'add');
        $.ajax({
            url: route,
            type: "POST",
            data: formdata,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 8000000,
            success: function (result) {
                if (result.status == 1) {
                    notify("success", result.msg);
                    $("#add-modal").modal("hide");
                    $("#" + form_id)[0].reset();
                    $("#data-table").DataTable().ajax.reload();
                    destroyLoader('add-btn', title, 'btn-primary')
                }
                if (result.status == 0) {
                    notify("danger", "Error", result.msg);
                    destroyLoader('add-btn', title, 'btn-primary')
                }
            },
            error: function (xhr, err) {
                var errorMessage = xhr.responseJSON.message;
                notify("danger", errorMessage);
                destroyLoader('add-btn', title, 'btn-primary')
            }
        });
    }
}

$(document).on('click', '.edit-item', function () {
    var title = $(this).html();
    var btn_id = $(this).attr('id');
    var route = $(this).data('route');
    initLoader(btn_id, title, 'btn', 'S')
    $.ajax({
        url: route,
        type: "POST",
        data: {
            type: "modal",
        },
        success: function (result) {
            if (result.status == 1) {
                $("#edit-modal").modal("show");
                $("#edit-form").html(result.payload);
                destroyLoader(btn_id, title, 'btn', 'S')
            }
            if (result.status == 0) {
                notify("danger", "Error", result.message);
                destroyLoader(btn_id, title, 'btn', 'S')
            }
        },
        error: function (xhr, err) {
            var errorMessage = xhr.responseJSON.message;
            notify("danger", errorMessage);
            destroyLoader(btn_id, title, 'btn', 'S')
        }
    });
});

let update_form = (e, element) => {
    var form_id = $(element).closest('.modal-content').find('form').attr('id');
    var title = $(element).html()
    var forms = $("#" + form_id);
    var route = $("input[name='edit_url']").val();

    forms.parsley().validate();
    initLoader('update-btn', '', 'btn-primary');
    if (!forms.parsley().isValid()) {
        destroyLoader('update-btn', title, 'btn-primary')
        return false;
    }
    e.preventDefault();
    if (forms.parsley().isValid()) {
        var formdata = new FormData($("#" + form_id)[0]);
        formdata.append('type', 'edit');
        $.ajax({
            url: route,
            type: "POST",
            data: formdata,
            processData: false,
            contentType: false,
            cache: false,
            timeout: 8000000,
            success: function (result) {
                if (result.status == 1) {
                    notify("success", result.msg);
                    $("#edit-modal").modal("hide");
                    $("#" + form_id)[0].reset();
                    $("#data-table").DataTable().ajax.reload();
                    destroyLoader('update-btn', title, 'btn-primary')
                }
                if (result.status == 0) {
                    notify("danger", "Error", result.msg);
                    destroyLoader('update-btn', title, 'btn-primary')
                }
            },
            error: function (xhr, err) {
                var errorMessage = xhr.responseJSON.message;
                notify("danger", errorMessage);
                destroyLoader('update-btn', title, 'btn-primary')
            }
        });
    }
}
let table = $('#data-table').DataTable({
    processing: true,
    serverSide: true,
    ajax: {
        url: QUIZ_LIST_URL, // jo tum already use kar rahe ho
        data: function (d) {
            d.course_id = $('#courseFilter').val(); // 🔥 dropdown value
        }
    },
    columns: [
        { data: 'id' },
        { data: 'course' },
        { data: 'question' },
        { data: 'type' },
        { data: 'points' },
        { data: 'order' },
        { data: 'active' },
        { data: 'action' }
    ]
});

// dropdown change par table reload
$('#courseFilter').on('change', function () {
    table.ajax.reload();
});
