$.ajaxSetup({
    headers: {
        "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
    },
});
// ======================================= Init date picker ======================================

function refreshCsrfToken() {
    $.get('/refresh-csrf', function (data) {
        $('meta[name="csrf-token"]').attr('content', data.csrf_token);
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': data.csrf_token
            }
        });
    });
}

function init_datepicker(picker, start, end, datalist) {
    picker.daterangepicker({
        startDate: start,
        endDate: end,
        opens: 'left',
        minDate: moment().subtract(4, 'months'),
        maxDate: moment(),
        ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            'Last 3 Months': [moment().subtract(3, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
            // 'This Year': [moment().startOf('year'), moment().endOf('year')]
        }
    }, function (start, end, label) {
        datalist({
            start: start,
            end: end,
            label: label
        });
    });
}

let init_tooltip = () => {
    $('[data-toggle="tooltip"]').tooltip();
};

// ==================== loader ===================
let initLoader = (id, text, className, type = "N") => {
    $(`#${id}`).html("");
    $(`#${id}`).removeClass(className);
    $(`#${id}`).attr("disabled", true);
    if (type == "N") {
        $(`#${id}`).css("min-width", "150px");
        $(`#${id}`).css("text-align", "center");
    }
    let loaderClass = type == "S" ? "spinner_loader" : "";
    $(`#${id}`)
        .html(`<div class="spinner-border text-primary ${loaderClass}" role="status" id="initLoader">
	<span class="btn sr-only">Loading...</span>
	</div>`);
};

let destroyLoader = (id, text, className, style = "N") => {
    $(`#${id}`).html("");
    $(`#${id}`).addClass(className);
    $(`#${id}`).removeAttr("disabled");
    if (style == "N") {
        $(`#${id}`).removeAttr("style");
    }
    setTimeout(() => {
        $(`#${id}`).html(text);
    }, 100);
};

const is_responsive = true
//===================================== DATA TABLE CONFIGURATION ========================================//
window.datatableConfig = {
    destroy: true,
    stateSave: true,
    responsive: true,
    bAutoWidth: true,
    buttons: ['copy', 'csv', 'print'],
    dom: '<"row"<"col-md-7 applyall"><"col-md-5 d-flex align-items-center justify-content-end gap-3" fB>><t><"table-footer-wrapper" <"row"<"col-md-6 d-flex align-items-center gap-3 pt-dropdown-wrapper" il><"col-md-6 d-flex align-items-center justify-content-end gap-3" p>>>',
    oLanguage: {
        sSearch: "",
        sSearchPlaceholder: "Search",
        oPaginate: {
            "sPrevious": `<img src="${BASEURL}/assets/images/svg/chevron-left.svg" width="20" alt="Previous">`,
            "sNext": `<img src="${BASEURL}/assets/images/svg/chevron-right.svg" width="20" alt="Next">`,
        }
    },
    ordering: true,
    rowReorder: false,
    searchDelay: 200,
    processing: true,
    serverSide: false,
    lengthMenu: [
        [10, 25, 50, -1],
        [10, 25, 50, 100],
    ],
    drawCallback: function () {
        init_tooltip();
    },
    order: [
        [0, "desc"]
    ],
};

let notify = (type, title, desc="") => {
    let config = {
        success: {
            color: "linear-gradient(to right, #00b09b, #96c93d)",
            icon: "✅"
        },
        danger: {
            color: "linear-gradient(to right, #ff5f6d, #d63031)",
            icon: "❌"
        },
        warning: {
            color: "linear-gradient(to right, #f7b733, #fc4a1a)",
            icon: "⚠️"
        }
    };
    let selected = config[type] || config.success;

    Toastify({
        text: `${selected.icon} <b>${title}</b><br>${desc}`,
        duration: 3000,
        close: true,
        gravity: "bottom",
        position: "right",
        stopOnFocus: true,
        escapeMarkup: false,
        style: {
            background: selected.color,
        }
    }).showToast();
};

// swal delete
$(document).on("click", ".delete", function () {
    var element = $(this);
    let id = $(this).data("id");
    let table = $(this).attr("table");
    let dtable = "data-table";
    confirm_sweet("Are you sure! You want to delete ?").then((action) => {
        if (action) {
            $.ajax({
                url: "/admin/delete",
                method: "POST",
                data: {
                    id: id,
                    table: table,
                },
                success: function (result) {
                    if (result.status == 1) {
                        $(element).parent().parent().remove();
                        info_sweet_alert(
                            "Success",
                            "Record deleted successfully"
                        );
                    } else {
                        info_sweet_alert(
                            "Error",
                            "Something Went Wrong while deleting",
                            "error"
                        );
                    }
                    $("#data-table").DataTable().ajax.reload();
                },
                error: function (xhr, err) {
                    notify("warning", "Oh snap!", "Something went wrong");
                },
            });
        }
    });
});

$(document).on("click", ".status_btn", function () {
    let id = $(this).data("id");
    let table = $(this).attr("table");
    let status = $(this).data("status");
  
    confirm_sweet("Are you sure! You want to update status ?").then(
        (action) => {
            if (action) {
                $.ajax({
                    url: "/admin/status-update",
                    method: "POST",
                    data: {
                        id: id,
                        table: table,
                        status: status,
                    },
                    success: function (data) {
                        $('#data-table').DataTable().ajax.reload();
                    },
                });
            }
        }
    );
});

let confirm_sweet = (text, title = "Confirmation") => {
    return new Promise((resolve) => {
        swal.fire({
            title: title,
            text: text,
            type: "question",
            buttonsStyling: !1,
            showCancelButton: true,
            confirmButtonText: "Yes, proceed !",
            cancelButtonText: "No, cancel",
            confirmButtonClass: "btn btn-primary",
            cancelButtonClass: "btn btn-secondary mx-3",
        }).then((action) => {
            if (action.value == true) {
                resolve(true);
            } else {
                resolve(false);
            }
        });
    });
};

let info_sweet_alert = (title, text, type = "success") => {
    if (type == "success") {
        swal.fire({
            icon: "success",
            title: title,
            text: text,
            confirmButtonClass: "btn-success",
            type: "success",
        });
    } else {
        swal.fire({
            title: title,
            text: text,
            confirmButtonClass: "btn-danger",
            type: "error",
        });
    }
};
