<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('quiz_questions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('course_id');
            $table->text('question_text');
            $table->enum('question_type', ['mcq_single', 'true_false', 'multi_select'])->default('mcq_single');
            $table->text('explanation_text')->nullable();
            $table->unsignedInteger('points')->default(1);
            $table->unsignedInteger('order_index')->default(1);
            $table->enum('is_active', ['1', '0'])->default('1');
            $table->enum('is_deleted', ['Y', 'N'])->default('N');
            $table->timestamps();

            $table->foreign('course_id')->references('id')->on('courses')->onDelete('cascade');
      
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quiz_questions');
    }
};
