<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Courses extends Model
{
    protected $fillable = [
        'program_id',
        'title',
        'description',
        'order_index',
        'video_url',
        'slides_url',
        'transcript',
        'has_quiz',
        'passing_percent',
        'allow_unlimited_attempts',
        'max_attempts',
        'unlock_type',
        'prerequisite_course_id',
        'prerequisite_condition',
        'is_active',
        'is_deleted'
    ];

    protected $hidden = [
        'is_deleted'
    ];

    public function program()
    {
        return $this->belongsTo(Programs::class);
    }

    public function prerequisite()
    {
        return $this->belongsTo(Courses::class, 'prerequisite_course_id');
    }
    public function files()
    {
        return $this->hasMany(CourseFiles::class, 'course_id');
    }
}
