<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Banners;
use App\Models\Categories;
use App\Models\ChildServiceDetails;
use App\Models\ChildServices;
use App\Models\Portfolio;
use App\Models\Programs;
use App\Models\Services;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class CrudController extends Controller
{
    public function programs(Request $request)
    {
        if ($request->isMethod("get")) {
            $title = "Programs";
            return view("admin.sp-modules.programs", compact("title"));
        }
        if ($request->isMethod("post")) {
            $data = Programs::where('is_deleted', 'N')->get();
            $records = [];
            $totalCount = count($data);
            if ($totalCount > 0) {
                foreach ($data as $key => $val) {
                    $actions = '<div class="action-perform-btns">
                        <a class="edit-item btn p-0 " id="edit_btn_' . $val->id . '" data-route="' . route('programs.add_edit', ['id' => $val->id]) . '"  aria-label="Edit" data-bs-original-title="Edit"><i class="bi bi-pencil-square"></i></a>
                        <a table="programs" class="delete" href="javascript:void(0);" data-id="' . $val->id . '"  aria-label="Delete" data-bs-original-title="Delete">
                        <i class="bi bi-trash"></i>
                        </a>
                    </div>';
                    $records[] = [
                        "SNO" => ++$key,
                        "TITLE" => $val->title,
                        "DESC" => $val->description,
                        "STATUS" => '<button table="programs" data-id="' . $val->id . '" data-status="' . ($val->status == 1 ? '0' : '1') . '" class="status_btn badge-sm badge ' . ($val->status == 1 ? 'bg-success' : 'bg-danger') . '">' . ($val->status == 1 ? 'Active' : 'InActive') . '</button>',
                        "ACTIONS" => $actions,
                    ];
                }
            }
            $arraylist = array(
                'TotalRecords' => $totalCount,
                'aaData' => $records,
            );
            echo compressJson($arraylist);
        }
    }

    public function add_edit_program(Request $request, $id = null)
    {
        if ($request->isMethod('post')) {
            if ($request->type == "modal") {
                $record = Programs::where('is_deleted', 'N')->where('id', $id)->first();
                $html = '<div class="form-group mb-3">
                        <label for="floatingInput">Title</label>
                        <input type="text" name="title" class="form-control" value="' . $record->title . '" id="title" required="true">
                    </div>
                    <div class="form-group mb-3">
                        <label for="floatingInput">Description</label>
                        <input type="text" name="description" value="' . $record->description . '" class="form-control" id="description" required="true">
                    </div>
                    <div class="form-group mb-3">
                        <input type="hidden" name="row_id" value="' . $record->id . '">
                        <input type="hidden" name="edit_url" value="' . route('programs.add_edit', ['id' => $record->id]) . '">
                        
                    </div>';
                $data = ['status' => 1, 'msg' => "Programs details", "payload" => [$html]];
            } else {
                $request->validate([
                    "title" => "required|string",
                    "description" => "required|string",
                ]);

                $title = $request->input('title');
                $description = $request->input('description');

                if ($id) {
                    $record = Programs::find($id);
                    if (!$record) {
                        return response()->json(['status' => 0, 'msg' => "Program not found", "payload" => []]);
                    }
                  
                    $record->title = $title;
                    $record->description = $description;
                    $query = $record->save();
                    $message = "Program updated successfully";
                } else {
                    $query = Programs::create(['title' => "$title","description" => "$description"]);
                    $message = "Program added successfully";
                }

                if ($query) {
                    return response()->json(['status' => 1, 'msg' => $message, "payload" => []]);
                } else {
                    return response()->json(['status' => 0, 'msg' => "Something went wrong while saving program", "payload" => []]);
                }
            }

            return response()->json($data);
        }
    }

    
public function users(Request $request)
{
    if ($request->isMethod("get")) {
        $title = "Users";
        return view("admin.sp-modules.users", compact("title"));
    }

    if ($request->isMethod("post")) {
        $data = User::query()->where('is_deleted','N')->where('role','!=','super_admin')->get();

        $records = [];
        $totalCount = count($data);

        if ($totalCount > 0) {
            foreach ($data as $key => $val) {

                $actions = '<div class="action-perform-btns">
                    <a class="edit-item btn p-0" id="edit_btn_' . $val->id . '" data-route="' . route('users.add_edit', ['id' => $val->id]) . '" aria-label="Edit" data-bs-original-title="Edit">
                        <i class="bi bi-pencil-square"></i>
                    </a>
                    <a table="users" class="delete" href="javascript:void(0);" data-id="' . $val->id . '" aria-label="Delete" data-bs-original-title="Delete">
                        <i class="bi bi-trash"></i>
                    </a>
                </div>';

                $records[] = [
                    "SNO" => ++$key,
                    "NAME" => $val->name,
                    "EMAIL" => $val->email,
                    "ROLE" => ucfirst(str_replace('_', ' ', $val->role)),
                    "STATUS" => '<button table="users" data-id="' . $val->id . '" data-status="' . ($val->is_active == '1' ? '0' : '1') . '" class="status_btn badge-sm badge ' . ($val->is_active == '1' ? 'bg-success' : 'bg-danger') . '">' . ($val->is_active == '1' ? 'Active' : 'InActive') . '</button>',
                    "ACTIONS" => $actions,
                ];
            }
        }

        $arraylist = array(
            'TotalRecords' => $totalCount,
            'aaData' => $records,
        );

        echo compressJson($arraylist);
    }
}

public function add_edit_user(Request $request, $id = null)
{
    if ($request->isMethod('post')) {

        // EDIT MODAL HTML
        if ($request->type == "modal") {

            $record = User::where('id', $id)->first();

            if (!$record) {
                return response()->json(['status' => 0, 'msg' => "User not found", "payload" => []]);
            }

            $roleOptions = '';
            foreach (['driver' => 'Driver', 'admin' => 'Admin'] as $k => $v) {
                $selected = ($record->role == $k) ? 'selected' : '';
                $roleOptions .= '<option value="' . $k . '" ' . $selected . '>' . $v . '</option>';
            }

            $statusOptions = '';
            foreach (['active' => 'Active', 'inactive' => 'Inactive', 'pending' => 'Pending'] as $k => $v) {
                $selected = ($record->status == $k) ? 'selected' : '';
                $statusOptions .= '<option value="' . $k . '" ' . $selected . '>' . $v . '</option>';
            }

            $html = '
                <div class="form-group mb-3">
                    <label>Name</label>
                    <input type="text" name="name" class="form-control" value="' . e($record->name) . '" required="true">
                </div>

                <div class="form-group mb-3">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" value="' . e($record->email) . '" required="true">
                </div>

                <div class="form-group mb-3">
                    <label>Password (optional)</label>
                    <input type="password" name="password" class="form-control" placeholder="Leave blank to keep current password">
                </div>

                <div class="form-group mb-3">
                    <label>Role</label>
                    <select name="role" class="form-control" required="true">
                        ' . $roleOptions . '
                    </select>
                </div>

                <div class="form-group mb-3">
                    <label>Status</label>
                    <select name="status" class="form-control" required="true">
                        ' . $statusOptions . '
                    </select>
                </div>

                <div class="form-group mb-3">
                    <input type="hidden" name="row_id" value="' . $record->id . '">
                    <input type="hidden" name="edit_url" value="' . route('users.add_edit', ['id' => $record->id]) . '">
                </div>
            ';

            $data = ['status' => 1, 'msg' => "User details", "payload" => [$html]];
            return response()->json($data);
        }

        // SAVE ADD/EDIT
        $rules = [
            "name" => "required|string|max:255",
            "email" => "required|email|max:255",
            "role" => "required|in:admin,driver",
        ];

        // password required only on create
        if (!$id) {
            $rules["password"] = "required|string|min:6";
        } else {
            $rules["password"] = "nullable|string|min:6";
        }

        // unique email rule
        $rules["email"] = $id
            ? "required|email|max:255|unique:users,email," . $id
            : "required|email|max:255|unique:users,email";

        $request->validate($rules);

        $name = $request->input('name');
        $email = $request->input('email');
        $role = $request->input('role');
        $password = $request->input('password');

        if ($id) {
            $record = User::find($id);
            if (!$record) {
                return response()->json(['status' => 0, 'msg' => "User not found", "payload" => []]);
            }

            $record->name = $name;
            $record->email = $email;
            $record->role = $role;

            // only update password if provided
            if (!empty($password)) {
                $record->password = Hash::make($password);
            }

            $query = $record->save();
            $message = "User updated successfully";
        } else {
            $query = User::create([
                'name' => $name,
                'email' => $email,
                'password' => Hash::make($password),
                'role' => $role,
            ]);

            $message = "User added successfully";
        }

        if ($query) {
            return response()->json(['status' => 1, 'msg' => $message, "payload" => []]);
        }

        return response()->json(['status' => 0, 'msg' => "Something went wrong while saving user", "payload" => []]);
    }
}
}
