<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CommonController extends Controller
{
    public function delete(Request $request)
    {
        $request->validate([
            "id"    => "required|integer",
            "table" => "required|string",
        ]);

        $id    = $request->id;
        $table = $request->table;

        // Check if table exists
        if (!Schema::hasTable($table)) {
            return response()->json([
                'status' => 0,
                'msg'    => "Table '{$table}' does not exist.",
                'payload' => []
            ]);
        }

        // Check if column 'is_deleted' exists in table
        if (!Schema::hasColumn($table, 'is_deleted')) {
            return response()->json([
                'status' => 0,
                'msg'    => "Column 'is_deleted' not found in '{$table}' table.",
                'payload' => []
            ]);
        }

        // Check if record exists
        $record = DB::table($table)->where('id', $id)->first();
        if (!$record) {
            return response()->json([
                'status' => 0,
                'msg'    => "Record with ID {$id} not found in '{$table}' table.",
                'payload' => []
            ]);
        }

        // Update is_deleted
        $deleted = DB::table($table)->where('id', $id)->update(['is_deleted' => 'Y']);

        if ($deleted) {
            return response()->json([
                'status' => 1,
                'msg'    => "Record marked as deleted successfully.",
                'payload' => []
            ]);
        } else {
            return response()->json([
                'status' => 0,
                'msg'    => "Failed to mark record as deleted.",
                'payload' => []
            ]);
        }
    }
    public function status_update(Request $request)
    {
        $request->validate([
            "id" => "required",
            "table" => "required",
            "status" => "required",
        ]);
        $id = $request->id;
        $table = $request->table;
        $status = $request->status;

        if (!Schema::hasTable($table)) {
            return response()->json([
                'status' => 0,
                'msg'    => "Table '{$table}' does not exist.",
                'payload' => []
            ]);
        }

        if (!Schema::hasColumn($table, 'status')) {
            return response()->json([
                'status' => 0,
                'msg'    => "Column 'status' not found in '{$table}' table.",
                'payload' => []
            ]);
        }

        $record = DB::table($table)->where('id', $id)->first();
        if (!$record) {
            return response()->json([
                'status' => 0,
                'msg'    => "Record with ID {$id} not found in '{$table}' table.",
                'payload' => []
            ]);
        }

        $updated = DB::table($table)->where('id', $id)->update(['status' => $status]);
        if ($updated) {
            $message = "Status updated successfully.";
            return response()->json([
                'status' => 1,
                'msg'    => $message,
                'payload' => []
            ]);
        } else {
            return response()->json([
                'status' => 0,
                'msg'    => "Failed to update status.",
                'payload' => []
            ]);
        }
    }
}
